/* ============ */
/* maxoftst.c	*/
/* ============ */
#include <defcodes.h>
#include <stdlib.h>
#include <math.h>
#include <maxtdefs.h>
#include <miscdefs.h>

#define	NUM_FINAL	100
/* ===================================================================== */
/* MaxofT - Applies Kolgomorov-Smirnov to a Maximum-of-t random sequence */
/* ===================================================================== */
void
main()
{
    int     i;
    double  KnMinusProb, KnMinusStat, KnPlusProb, KnPlusStat;

    double  KnPosProb[NUM_FINAL];
    double  KnNegProb[NUM_FINAL];

    MAXT_DATA_STRU  MaxtData;
    INIT_DATA_STRU  InitialData;

    AbortGracefully();			/* Make ^C act reasonably */

    printf("\tM A X I M U M  O F  T  T E S T\n\n");
    GetInitialData(&InitialData);
    fprintf(stderr, "\n"); fflush(NULL);
    /* -------------------------- */
    /* Print Initial Data Entries */
    /* -------------------------- */
    printf("\nStarting Seed = %u%s\n", InitialData.UserSeed,
	(InitialData.SeedSrce == (UINT)(-1)) ?
		" (Unsigned Integer Part of Time of Day)" : "");
    printf("Generator     = %s\n", InitialData.GenName);

    MaxtData.RandFun = InitialData.RandFun;

    SetMaxOfTControls(&MaxtData);

    /* --------------------------------- */
    /* Initialize Randon Variate Counter */
    /* --------------------------------- */
    MaxtData.TotNumGen = 0;

    fflush(NULL);
    /* ----------------------------- */
    /* Gather Data for KS-on-KS Test */
    /* ----------------------------- */
    for (i = 0; i < NUM_FINAL; ++i)
    {
	ApplyKStoMaxOfT(&MaxtData);

	fprintf(stderr, "\rPass %3d (of %d), %8ld  Total Random Numbers",
	    i+1, NUM_FINAL, MaxtData.TotNumGen);

	KnPosProb[i] = MaxtData.ProbKSPos;
	KnNegProb[i] = MaxtData.ProbKSNeg;
    }
    fflush(NULL);
    printf("\nResults for KS-on-KS Test:\n");
    /* ---------------------------------------------- */
    /* Calculate Statistics and Probabilities for Kn+ */
    /* ---------------------------------------------- */
    KSCalc(KnPosProb, NUM_FINAL, &KnPlusStat, &KnPlusProb,
	&KnMinusStat, &KnMinusProb);

    printf("\nStatistics and Probabilities for Kn+\n");

    printf("\tK(%d)+ = %f (Knuth) or %9f%%\n", NUM_FINAL,
	sqrt((double)NUM_FINAL)*KnPlusStat, 100*KnPlusProb);

    printf("\tK(%d)- = %f (Knuth) or %9f%%\n", NUM_FINAL,
	sqrt((double)NUM_FINAL)*KnMinusStat, 100*KnMinusProb);

    /* ---------------------------------------------- */
    /* Calculate Statistics and Probabilities for Kn- */
    /* ---------------------------------------------- */
    KSCalc(KnNegProb, NUM_FINAL, &KnPlusStat, &KnPlusProb,
	&KnMinusStat, &KnMinusProb);

    printf("\nStatistics and Probabilities for Kn-\n");

    printf("\tK(%d)+ = %f (Knuth) or %9f%%\n", NUM_FINAL,
	sqrt((double)NUM_FINAL)*KnPlusStat, 100*KnPlusProb);

    printf("\tK(%d)- = %f (Knuth) or %9f%%\n", NUM_FINAL,
	sqrt((double)NUM_FINAL)*KnMinusStat, 100*KnMinusProb);

    printf("\nThis Run Required %ld Random Numbers\n",
	MaxtData.TotNumGen);
}
